#pragma rtGlobals=1		// Use modern global access method.
#include "IN2_Load Indra 2"
#include  <New Polar Graphs>
Menu "USAXS"
	"CorrectAnisoData"
end

Function CorrectAnisoData()
	//function to correct aniso data for dark currents and blank data 
	
	string oldDf=GetDataFolder(1)
	
	//first find the folders which user wants to correct
	//and find blank run from which we can pull the correction parameters
	string SampleFolderName
	string BlankFolderName
	
	Prompt SampleFolderName, "Select Aniso Folder", popup, IN2G_FindFolderWithWaveTypes("root:Others:", 5, "USAXS_PD", 1)
	Prompt BlankFolderName, "Select Blank run Folder", popup, IN2G_FindFolderWithWaveTypes("root:USAXS:", 5, "USAXS_PD", 1)
	
	DoPrompt "Select data to corect", SampleFolderName, BlankFolderName
	
	Wave AnisoUSAXS_PD=$(SampleFolderName+"USAXS_PD")
	Wave AnisoPD_range=$(SampleFolderName+"pd_range")
	Wave AnisoSeconds=$(SampleFolderName+"seconds")
	Wave AnisoAR_enc=$(SampleFolderName+"ar_enc")
	Wave AnisoMonitor=$(SampleFolderName+"I0")
	SVAR AnisoMeasPar=$(SampleFolderName+"MeasurementParameters")

	Wave BlankUSAXS_PD=$(BlankFolderName+"USAXS_PD")
	Wave BlankPD_range=$(BlankFolderName+"pd_range")
	Wave BlankSeconds=$(BlankFolderName+"MeasTime")
	Wave BlankAR_enc=$(BlankFolderName+"ar_encoder")
	Wave BlankMonitor=$(BlankFolderName+"Monitor")
	SVAR BlankMeasPar=$(BlankFolderName+"MeasurementParameters")

	variable AnisoPDDarkCurrent=NumberByKey("UPD2bkg"+num2str(AnisoPD_range[0]), AnisoMeasPar , ":", ";")
	variable BlankUPDVal=interp(AnisoAR_enc[0], BlankAR_enc, BlankUSAXS_PD )
	variable BlankPD_rangeVal=floor(interp(AnisoAR_enc[0], BlankAR_enc, BlankPD_range ))
	variable RangeDifference=BlankPD_rangeVal-AnisoPD_range[0]
	if (RangeDifference<0)
		Abort "Ranges weird - blank range is higher than sample" 
	endif
	variable BlankPDDarkCurrent=NumberByKey("UPD2bkg"+num2str(BlankPD_rangeVal), BlankMeasPar , "=", ";")

	
	
	// BlankFolderName
	// SampleFolderName
	setDataFolder $SampleFolderName
	
	Duplicate/O AnisoUSAXS_PD, AnisoIntensityCorr, TempAnisoBlInt
	Wave AnisoIntensityCorr
	Wave TempAnisoBlInt
	
	
	AnisoIntensityCorr=AnisoUSAXS_PD - (AnisoPDDarkCurrent*AnisoSeconds	)	//this fixes the USAXS PD for dark current
	TempAnisoBlInt= (BlankUPDVal - (BlankSeconds * BlankPDDarkCurrent)) / 10^(2*RangeDifference)
	
	AnisoIntensityCorr= AnisoIntensityCorr - (TempAnisoBlInt * AnisoMonitor / BlankMonitor)

	killWaves TempAnisoBlInt
	
	setDataFolder oldDf


end